package issue

import (
	"context"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type FocusIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 关注issue
func NewFocusIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *FocusIssueLogic {
	return &FocusIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *FocusIssueLogic) FocusIssue(req *types.FollowHandleReq) (resp *types.IssueResp, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	_, err = l.svcCtx.IssueCenterRpc.FollowIssue(l.ctx, &issuerpc.FollowIssueReq{
		Email:   userInfo.Email,
		IssueId: req.ID,
		Handle:  req.Handle,
	})
	if err != nil {
		return nil, err
	}

	return resp, nil
}
