package issue

import (
	"context"

	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type GetIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// get issue detail by id
func NewGetIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetIssueLogic {
	return &GetIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetIssueLogic) GetIssue(req *types.GetIssueReq) (resp *types.IssueInfo, err error) {
	// 调用 RPC 层获取 issue 详细信息
	rpcResp, err := l.svcCtx.IssueCenterRpc.GetIssue(l.ctx, &issuerpc.GetIssueReq{
		Id: req.Id,
	})
	if err != nil {
		l.Logger.Errorf("Failed to get issue details: %v", err)
		return nil, errors.Wrap(err, "failed to get issue details from RPC")
	}

	// 将从 RPC 层获取的数据转换为 API 层的数据结构
	resp = &types.IssueInfo{
		Id:                  rpcResp.Id,
		Title:               rpcResp.Title,
		Content:             rpcResp.Content,
		Severity:            rpcResp.Severity,
		Status:              rpcResp.Status,
		AssignedTo:          rpcResp.AssignedTo,
		Reporter:            rpcResp.Reporter,
		Tester:              rpcResp.Tester,
		Developer:           rpcResp.Developer,
		ProductManager:      rpcResp.ProductManager,
		AffectedVersion:     rpcResp.AffectedVersion,
		FixVersion:          rpcResp.FixVersion,
		Attachments:         rpcResp.Attachments,
		Type:                rpcResp.Type,
		ProcessPos:          rpcResp.ProcessPos,
		ProcessStatus:       rpcResp.ProcessStatus,
		ProcessApprover:     rpcResp.ProcessApprover,
		ProcessApproverCode: rpcResp.ProcessApproverCode,
		ProcessID:           rpcResp.ProcessID,
		CreateAt:            rpcResp.CreateAt,
	}
	return resp, nil
}
