package issue

import (
	"context"

	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type GetIssueProcessInfoLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// get issue process detail by id
func NewGetIssueProcessInfoLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetIssueProcessInfoLogic {
	return &GetIssueProcessInfoLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetIssueProcessInfoLogic) GetIssueProcessInfo(req *types.IssueProcessInfoReq) (resp *types.IssueProcessInfo, err error) {
	rpcResp, err := l.svcCtx.IssueCenterRpc.GetIssueProcessInfo(l.ctx, &issuerpc.GetIssueProcessReq{
		Id: req.Id,
	})

	if err != nil {
		l.Logger.Errorf("Failed to get issue details: %v", err)
		return nil, errors.Wrap(err, "failed to get issue details from RPC")
	}

	resp = &types.IssueProcessInfo{
		Id:             rpcResp.Id,
		IssueId:        rpcResp.IssueId,
		Pos:            rpcResp.Pos,
		Approver:       rpcResp.Approver,
		ApproverCode:   int(rpcResp.ApproverCode),
		Status:         int(rpcResp.Status),
		ProcessHandler: rpcResp.ProcessHandler,
		Remark:         rpcResp.Remark,
		CreateAt:       rpcResp.CreateAt,
		UpdateAt:       rpcResp.UpdateAt,
		Attachments:    rpcResp.Attachments,
		Tag:            rpcResp.Tag,
	}
	return
}
