package issue

import (
	"context"
	"fmt"
	"oa-server/common/ctxdata"

	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type HandleIssueProcessLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 处理 issue
func NewHandleIssueProcessLogic(ctx context.Context, svcCtx *svc.ServiceContext) *HandleIssueProcessLogic {
	return &HandleIssueProcessLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *HandleIssueProcessLogic) HandleIssueProcess(req *types.HandleProcessReq) (*types.HandleProcessResp, error) {

	userEmail := ctxdata.GetUserFromCtx(l.ctx)
	// 构建RPC层的请求数据
	rpcReq := &issuerpc.HandleProcessRequest{
		Id:          req.Id,
		Status:      req.Status,
		Remark:      req.Remark,
		Developer:   req.Developer,
		Handler:     userEmail.Email,
		Tester:      req.Tester,
		Attachments: req.Attachments,
		AssignType:  req.Assign_type,
		Tag:         req.Tag,
	}

	// 调用RPC层的HandleProcess方法
	rpcResp, err := l.svcCtx.IssueCenterRpc.HandleProcess(l.ctx, rpcReq)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("调用RPC处理流程失败, Issue Id: %d", req.Id))
	}

	// 构建API层的响应数据
	resp := &types.HandleProcessResp{
		Id: rpcResp.Id,
	}
	return resp, nil
}
