package issue

import (
	"context"

	"github.com/jinzhu/copier"
	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type ListIssueProcessesLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取指定issue的流程状态列表
func NewListIssueProcessesLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListIssueProcessesLogic {
	return &ListIssueProcessesLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ListIssueProcessesLogic) ListIssueProcesses(req *types.ListIssueProcessReq) (*types.ListIssueProcessResp, error) {
	issueListResp, err := l.svcCtx.IssueCenterRpc.ListIssueProcesses(l.ctx, &issuerpc.ListIssueProcessRequest{
		IssueId: req.Id,
	})
	if err != nil {
		return nil, errors.Wrapf(err, "req: %+v", req)
	}

	var resp types.ListIssueProcessResp
	if err := copier.Copy(&resp.IssueProcess, issueListResp.Processes); err != nil {
		return nil, errors.Wrap(err, "failed to copy issue process data")
	}
	resp.Total = issueListResp.Total

	return &resp, nil
}
