package issue

import (
	"context"

	"github.com/jinzhu/copier"
	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type ListIssuesLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取issue列表
func NewListIssuesLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListIssuesLogic {
	return &ListIssuesLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ListIssuesLogic) ListIssues(req *types.ListIssueReq) (*types.ListIssueResp, error) {
	issueListResp, err := l.svcCtx.IssueCenterRpc.ListIssues(l.ctx, &issuerpc.ListIssueReq{
		Status:   req.Status,
		Severity: req.Severity,
		Title:    req.Title,
		Page:     req.Page,
		PageSize: req.PageSize,
	})
	if err != nil {
		return nil, errors.Wrapf(err, "req: %+v", req)
	}

	var resp types.ListIssueResp
	if err := copier.Copy(&resp.Issues, issueListResp.Issues); err != nil {
		return nil, errors.Wrap(err, "failed to copy issue data")
	}
	resp.Total = issueListResp.Total

	return &resp, nil
}
