package issue

import (
	"context"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/common/ctxdata"

	"github.com/jinzhu/copier"
	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"
)

type MyFollowLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 我的关注
func NewMyFollowLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MyFollowLogic {
	return &MyFollowLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MyFollowLogic) MyFollow(req *types.MyDoneReq) (resp *types.ListIssueResp, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	data, err := l.svcCtx.IssueCenterRpc.MyFollow(l.ctx, &issuerpc.MyDoneReq{
		Email:    userInfo.Email,
		Page:     req.Page,
		PageSize: req.PageSize,
	})
	if err != nil {
		return nil, errors.Wrap(err, "failed to get my done issue from RPC")
	}
	resp = &types.ListIssueResp{}
	resp.Total = data.Total

	_ = copier.Copy(&resp.Issues, data.Issues)
	return resp, nil
}
