package issue

import (
	"context"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/common/ctxdata"

	"github.com/jinzhu/copier"
	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"
)

type MySubmitLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 我的提交
func NewMySubmitLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MySubmitLogic {
	return &MySubmitLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MySubmitLogic) MySubmit(req *types.ListIssueReq) (resp *types.ListIssueResp, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	issueListResp, err := l.svcCtx.IssueCenterRpc.MySubmit(l.ctx, &issuerpc.MyListIssueReq{
		Status:   req.Status,
		Severity: req.Severity,
		Title:    req.Title,
		Page:     req.Page,
		PageSize: req.PageSize,
		Email:    userInfo.Email,
	})
	resp = &types.ListIssueResp{}
	if err != nil {
		return nil, errors.Wrapf(err, "req: %+v", req)
	}
	if err := copier.Copy(&resp.Issues, issueListResp.Issues); err != nil {
		return nil, errors.Wrap(err, "failed to copy issue data")
	}
	resp.Total = issueListResp.Total

	return resp, nil
}
