package issue

import (
	"context"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type MyWorkbenchLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 我的工作台数量
func NewMyWorkbenchLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MyWorkbenchLogic {
	return &MyWorkbenchLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MyWorkbenchLogic) MyWorkbench() (resp *types.MyWorkbenchRep, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	issueListResp, err := l.svcCtx.IssueCenterRpc.MyWorkbench(l.ctx, &issuerpc.MyWorkbenchReq{
		Email: userInfo.Email,
	})
	if err != nil {
		return nil, err
	}
	resp = &types.MyWorkbenchRep{}
	resp.Data = issueListResp.Data
	return resp, nil
}
