package issue

import (
	"context"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/pkg/errors"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type SoftDeleteIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// soft delete issue
func NewSoftDeleteIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *SoftDeleteIssueLogic {
	return &SoftDeleteIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *SoftDeleteIssueLogic) SoftDeleteIssue(req *types.SoftDeleteIssueReq) (*types.SoftDeleteIssueResp, error) {
	resp, err := l.svcCtx.IssueCenterRpc.SoftDeleteIssue(l.ctx, &issuerpc.SoftDeleteIssueReq{
		IssueId: req.IssueId,
	})
	if err != nil {
		return nil, errors.Wrapf(err, "failed to soft delete issue with id %d", req.IssueId)
	}

	return &types.SoftDeleteIssueResp{
		IssueId: resp.IssueId,
	}, nil
}
