package issue

import (
	"context"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/common/ctxdata"

	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"
)

type TransferIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 流转issue
func NewTransferIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *TransferIssueLogic {
	return &TransferIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *TransferIssueLogic) TransferIssue(req *types.TransferReq) (resp *types.UpdateRepairStatusResp, err error) {
	userEmail := ctxdata.GetUserFromCtx(l.ctx)
	rpcReq := &issuerpc.TransferReq{
		Id:            req.Id,
		EstimatedTime: req.EstimatedTime,
		Note:          req.Note,
		Approver:      req.Approver,
		Email:         userEmail.Email,
		Attachments:   req.Attachments,
		Tag:           req.Tag,
		Pos:           req.Pos,
		HandleStatus:  req.HandleStatus,
	}

	rpcResp, err := l.svcCtx.IssueCenterRpc.TransferIssue(l.ctx, rpcReq)
	if err != nil {
		l.Logger.Errorf("Failed to update repair status for issue id %s: %v", req.Id, err)
		return nil, errors.Wrap(err, "failed to update repair status")
	}

	return &types.UpdateRepairStatusResp{
		Success: rpcResp.Success,
	}, nil
}
