package issue

import (
	"context"

	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type UpdateIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// update an issue by id
func NewUpdateIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateIssueLogic {
	return &UpdateIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateIssueLogic) UpdateIssue(req *types.UpdateIssueReq) (resp *types.UpdateIssueResp, err error) {
	rpcReq := &issuerpc.UpdateIssueReq{
		Id:              req.Id,
		Title:           req.Title,
		Content:         req.Content,
		Severity:        req.Severity,
		Status:          req.Status,
		AssignedTo:      req.AssignedTo,
		Reporter:        req.Reporter,
		AffectedVersion: req.AffectedVersion,
		FixVersion:      req.FixVersion,
		Attachments:     req.Attachments,
		Type:            req.Type,
		Developer:       req.Developer,
		Tester:          req.Tester,
		ProductManager:  req.ProductManager,
	}

	rpcResp, err := l.svcCtx.IssueCenterRpc.UpdateIssue(l.ctx, rpcReq)
	if err != nil {
		l.Logger.Errorf("Failed to update issue with ID %d: %v", req.Id, err)
		return nil, errors.Wrap(err, "failed to update issue")
	}

	return &types.UpdateIssueResp{
		Id: rpcResp.Id,
	}, nil
}
