package issue

import (
	"context"
	"oa-server/common/ctxdata"

	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type UpdateRepairStatusLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 修复 issue
func NewUpdateRepairStatusLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateRepairStatusLogic {
	return &UpdateRepairStatusLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateRepairStatusLogic) UpdateRepairStatus(req *types.UpdateRepairStatusReq) (resp *types.UpdateRepairStatusResp, err error) {
	userEmail := ctxdata.GetUserFromCtx(l.ctx)
	rpcReq := &issuerpc.UpdateRepairStatusRequest{
		Id:            req.Id,
		EstimatedTime: req.EstimatedTime,
		Note:          req.Note,
		Status:        req.Status,
		Handler:       userEmail.Email,
		IsRejected:    req.IsRejected,
		Attachments:   req.Attachments,
		Tag:           req.Tag,
	}

	rpcResp, err := l.svcCtx.IssueCenterRpc.UpdateRepairStatus(l.ctx, rpcReq)
	if err != nil {
		l.Logger.Errorf("Failed to update repair status for issue id %s: %v", req.Id, err)
		return nil, errors.Wrap(err, "failed to update repair status")
	}

	return &types.UpdateRepairStatusResp{
		Success: rpcResp.Success,
	}, nil
}
