package svc

import (
	"oa-server/app/issuecenter/issueapi/internal/config"
	"oa-server/app/issuecenter/issuerpc/issuerpcclient"
	"oa-server/common/middleware"

	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"

	"github.com/zeromicro/go-zero/rest"
	"github.com/zeromicro/go-zero/zrpc"
)

type ServiceContext struct {
	Config         config.Config
	AuthMiddleware rest.Middleware
	IssueCenterRpc issuerpcclient.Issuerpc
}

func NewServiceContext(c config.Config) *ServiceContext {
	lbkUcClient, _ := lbkUc.NewLbkUserClient(c.LbkUsercenter.Env, c.LbkUsercenter.HostInAli)

	return &ServiceContext{
		Config:         c,
		IssueCenterRpc: issuerpcclient.NewIssuerpc(zrpc.MustNewClient(c.IssueCenterRpcConf)),
		AuthMiddleware: middleware.NewAuthMiddleware(c.LbkUsercenter.AppName, lbkUcClient).Handle,
	}
}
