// Code generated by goctl. DO NOT EDIT.
// goctl 1.8.1

package types

type CloseIssueReq struct {
	Id int64 `json:"id"`
}

type CloseIssueResp struct {
	Id int64 `json:"id"`
}

type FollowHandleReq struct {
	ID     uint32 `json:"id"`
	Handle uint32 `json:"handle"`
}

type GetIssueReq struct {
	Id int64 `json:"id":"id"`
}

type GetIssueResp struct {
	Id                  int64  `json:"id"`                  // 唯一标识符
	Title               string `json:"title"`               // 标题
	Content             string `json:"content"`             // 内容
	Severity            string `json:"severity"`            // 严重程度
	Status              int64  `json:"status"`              // 状态
	AssignedTo          string `json:"assignedTo"`          // 分配给
	Tester              string `json:"tester"`              // 测试
	Developer           string `json:"developer"`           // 产品负责人
	ProductManager      string `json:"productManager"`      // 提交人
	Reporter            string `json:"reporter"`            // 提交人
	AffectedVersion     string `json:"affectedVersion"`     // 影响版本
	FixVersion          string `json:"fixVersion"`          // 修复版本
	Attachments         string `json:"attachments"`         // 附件
	Type                int64  `json:"type"`                // 类型
	ProcessPos          int64  `json:"processPos"`          // 当前流程位置
	ProcessStatus       int64  `json:"processStatus"`       // 当前处理状态
	ProcessApprover     string `json:"processApprover"`     // 当前处理人
	ProcessApproverCode int64  `json:"processApproverCode"` // 当前处理角色
	ProcessID           int64  `json:"processID"`           // 当前处理流程 ID
	CreateAt            int64  `json:"createAt"`
	UpdateAt            int64  `json:"updateAt"`
}

type HandleProcessReq struct {
	Id          int64  `json:"id"`
	Status      int64  `json:"status"`     // 要更新的状态
	Assign_type int64  `json:"assignType"` // 分配类型: 1 表示普通处理, 2 表示测试 leader 分配测试, 3 表示测试分配研发和产品
	Remark      string `json:"remark"`
	Developer   string `json:"developer"`     // 开发
	Tester      string `json:"tester"`        // 测试
	Attachments string `json:"attachments"`   // 附件
	Tag         string `json:"tag, optional"` // 标签
}

type HandleProcessResp struct {
	Id int64 `json:"id"`
}

type IssueInfo struct {
	Id                  int64  `json:"id"`                  // 唯一标识符
	Title               string `json:"title"`               // 标题
	Content             string `json:"content"`             // 内容
	Severity            string `json:"severity"`            // 严重程度
	Status              int64  `json:"status"`              // 状态
	AssignedTo          string `json:"assignedTo"`          // 分配给
	Tester              string `json:"tester"`              // 测试
	Developer           string `json:"developer"`           // 开发
	ProductManager      string `json:"productManager"`      // 产品
	Reporter            string `json:"reporter"`            // 提交人
	AffectedVersion     string `json:"affectedVersion"`     // 影响版本
	FixVersion          string `json:"fixVersion"`          // 修复版本
	Attachments         string `json:"attachments"`         // 附件
	Type                int64  `json:"type"`                // 类型
	ProcessPos          int64  `json:"processPos"`          // 当前流程位置
	ProcessStatus       int64  `json:"processStatus"`       // 当前处理状态
	ProcessApprover     string `json:"processApprover"`     // 当前处理人
	ProcessApproverCode int64  `json:"processApproverCode"` // 当前处理角色
	ProcessID           int64  `json:"processID"`           // 当前处理流程 ID
	CreateAt            int64  `json:"createAt"`
	UpdateAt            int64  `json:"updateAt"`
}

type IssueProcessInfo struct {
	Id             int64  `json:"id"`
	IssueId        int64  `json:"issueId"`
	Pos            int64  `json:"pos"`
	Approver       string `json:"approver"`
	ApproverCode   int    `json:"approverCode"`
	Status         int    `json:"status"`
	ProcessHandler string `json:"processHandler"`
	Remark         string `json:"remark"`
	CreateAt       int64  `json:"createAt"`
	UpdateAt       int64  `json:"updateAt"`
	Attachments    string `json:"attachments"`
	Tag            string `json:"tag"`
}

type IssueProcessInfoReq struct {
	Id int64 `json:"id"`
}

type IssueReq struct {
	Title           string `json:"title"`           // 标题
	Content         string `json:"content"`         // 内容
	Severity        string `json:"severity"`        // 严重程度
	Status          int64  `json:"status"`          // 状态
	AssignedTo      string `json:"assignedTo"`      // 分配给
	Tester          string `json:"tester"`          // 测试
	Reporter        string `json:"reporter"`        // 测试
	AffectedVersion string `json:"affectedVersion"` // 影响版本
	FixVersion      string `json:"fixVersion"`      // 修复版本
	Attachments     string `json:"attachments"`     // 附件
	Type            int64  `json:"type"`            // 类型
}

type IssueResp struct {
	Id int64 `json:"id"`
}

type ListIssueProcessReq struct {
	Id int64 `json:"id"`
}

type ListIssueProcessResp struct {
	IssueProcess []IssueProcessInfo `json:"issues_process"` // 问题列表
	Total        int64              `json:"total"`          // 符合条件的问题总数
}

type ListIssueReq struct {
	Page     int32  `json:"page"`               // 请求的页码
	PageSize int32  `json:"pageSize"`           // 每页显示的条目数
	Title    string `json:"title, optional"`    // 标题
	Status   int64  `json:"status, optional"`   // 状态
	Severity string `json:"severity, optional"` // 严重程度
}

type ListIssueResp struct {
	Issues []IssueInfo `json:"issues"` // 问题列表
	Total  int64       `json:"total"`  // 符合条件的问题总数
}

type MyHandlerResp struct {
	List  []IssueProcessInfo `json:"list"`  // 问题列表
	Total int64              `json:"total"` // 符合条件的问题总数
}

type MySubmitReq struct {
	Id       int32  `json:"id"`       // 用户ID
	Username string `json:"username"` // 登录名
	ListIssueReq
}

type MySubmitResp struct {
	IssueList []IssueProcessInfo `json:"list"`  // 问题列表
	Total     int64              `json:"total"` // 符合条件的问题总数
}

type MyWorkbenchRep struct {
	Data []int64 `json:"data"`
}

type SoftDeleteIssueReq struct {
	IssueId int64 `json:"issueId"` // 要删除的问题 ID
}

type SoftDeleteIssueResp struct {
	IssueId int64 `json:"issueId"` // 要删除的问题 ID
}

type TransferReq struct {
	Id            int64  `json:"id"`
	EstimatedTime int64  `json:"estimatedTime"` // 预计时间
	Note          string `json:"note"`          // 备注
	Attachments   string `json:"attachments"`   // 修复附件
	HandleStatus  int64  `json:"is_rejected"`   // 1 允许  2 拒绝
	Tag           string `json:"tag"`           // 标签
	Approver      string `json:"approver"`      // 流转到下一个节点
	Pos           int64  `json:"pos"`           // 当前流程位置
}

type UpdateIssueReq struct {
	Id              int64  `json:"id"`
	Title           string `json:"title"`
	Content         string `json:"content"`
	Severity        string `json:"severity"`
	Status          int64  `json:"status"`
	AssignedTo      string `json:"assignedTo"`
	Tester          string `json:"tester"`         // 研发
	Developer       string `json:"developer"`      // 产品负责人
	ProductManager  string `json:"productManager"` // 提交人
	Reporter        string `json:"reporter"`
	AffectedVersion string `json:"affectedVersion"`
	FixVersion      string `json:"fixVersion"`
	Attachments     string `json:"attachments"`
	Type            int64  `json:"type"`
}

type UpdateIssueResp struct {
	Id int64 `json:"id"`
}

type UpdateRepairStatusReq struct {
	Id            int32  `json:"id"`
	EstimatedTime string `json:"estimatedTime"` // 预计时间
	Note          string `json:"note"`          // 备注
	Status        int32  `json:"status"`        // 状态  4 修复中  5 已修复
	Attachments   string `json:"attachments"`   // 修复附件
	IsRejected    int32  `json:"is_rejected"`   // 1 允许  2 拒绝
	Tag           string `json:"tag"`           // 标签
}

type UpdateRepairStatusResp struct {
	Success bool `json:"success"`
}

type MyDoneReq struct {
	Page     uint64 `json:"page"`
	PageSize uint64 `json:"pageSize"`
}
