package main

import (
	"flag"

	"github.com/zeromicro/go-zero/core/conf"
	"github.com/zeromicro/go-zero/rest"

	"oa-server/app/issuecenter/issueapi/internal/config"
	"oa-server/app/issuecenter/issueapi/internal/handler"
	"oa-server/app/issuecenter/issueapi/internal/svc"
)

var configFile = flag.String("f", "app/issuecenter/cmd/issueapi/etc/issue.yaml", "the config file")

func main() {
	flag.Parse()

	var c config.Config
	conf.MustLoad(*configFile, &c)

	server := rest.MustNewServer(c.RestConf)
	defer server.Stop()

	ctx := svc.NewServiceContext(c)
	handler.RegisterHandlers(server, ctx)

	// fmt.Printf("Starting server at %s:%d...\n", c.Host, c.Port)
	server.Start()
}
