package logic

import (
	"context"
	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/zeromicro/go-zero/core/stores/sqlx"

	"github.com/zeromicro/go-zero/core/logx"
)

type CloseIssueLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewCloseIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CloseIssueLogic {
	return &CloseIssueLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *CloseIssueLogic) CloseIssue(in *issuerpc.CloseIssueReq) (*issuerpc.CloseIssueResp, error) {
	l.Logger.Infof("Closing issue with ID: %d", in.Id)

	err := l.svcCtx.Db.Transact(func(session sqlx.Session) error {
		closeIssueQuery := `UPDATE x_issues SET status = 100 WHERE id = ?`

		_, err := session.ExecCtx(l.ctx, closeIssueQuery, in.Id)
		if err != nil {
			l.Logger.Errorf("Error while closing issue: %v", err)
			return err
		}
		return nil
	})

	if err != nil {
		return nil, err
	}
	return &issuerpc.CloseIssueResp{
		Id: in.Id,
	}, nil
}
