package logic

// 定义处理人的类型代码
const (
	Begin               = 0   // 流程开始
	DeveloperCode       = 1   // 开发
	DeveloperLeaderCode = 2   // 开发组长
	TesterCode          = 3   // 测试
	TesterLeaderCode    = 4   // 测试组长
	OpsCode             = 5   // 运维
	OpsLeaderCode       = 6   // 运维组长
	CreatorCode         = 7   // issue创建人
	ProductCode         = 8   // 产品
	ProductLeaderCode   = 9   // 产品组长
	EndingCode          = 100 // 流程结束
)

// 定义issue的类型
const (
	IssueDefaultType = 1 // issue 默认类型
)

// 状态
const (
	ApprovalStatusPending   = 0 // 默认状态
	ApprovalStatusWaiting   = 1 // 待处理 当前流转节点待确认
	ApprovalStatusConfirmed = 2 // 通过
	ApprovalStatusRejected  = 3 // 拒绝
	ApprovalStatusFixing    = 4 // 修复中
	ApprovalStatusFixed     = 5 // 已修复
	ApprovalStatusValidated = 6 // 已测试
	ApprovalStatusDeployed  = 7 // 已上线
)

// issue的所有状态
const (
	ReleaseStatusWait        = 0 // 待发布
	ReleaseStatusClose       = 1 // 手动关闭
	ReleaseStatusTimingClose = 2 // 定时关闭
)

const (
	CurrentRoleTester         = "currentTester"
	CurrentRoleDeveloper      = "currentDeveloper"
	CurrentRoleProductManager = "currentProductManager"
)
