package logic

import (
	"context"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"oa-server/app/issuecenter/model"

	"github.com/zeromicro/go-zero/core/logx"
)

type FollowIssueLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewFollowIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *FollowIssueLogic {
	return &FollowIssueLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *FollowIssueLogic) FollowIssue(in *issuerpc.FollowIssueReq) (*issuerpc.IssueResp, error) {
	var err error
	if in.Handle == 1 {
		// 关注
		_, err = l.svcCtx.UserFollowIssueModel.Insert(l.ctx, &model.XUserFollowIssue{
			Email:   in.Email,
			IssueId: uint64(in.IssueId),
		})

	} else {
		// 取消关注
		err = l.svcCtx.UserFollowIssueModel.DeleteByEmailAndIssueId(l.ctx, in.Email, uint64(in.IssueId))
	}
	return &issuerpc.IssueResp{}, err
}
