package logic

import (
	"context"
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/app/issuecenter/model"
)

type GetIssueLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetIssueLogic {
	return &GetIssueLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetIssueLogic) GetIssue(in *issuerpc.GetIssueReq) (*issuerpc.GetIssueResp, error) {
	var issue model.XIssues
	err := l.svcCtx.Db.QueryRow(&issue, "SELECT * FROM x_issues WHERE id = ?", in.Id)
	if err != nil {
		l.Logger.Errorf("Failed to find issue with ID %d, error: %v", in.Id, err)
		return nil, fmt.Errorf("failed to find issue with ID %d: %v", in.Id, err)
	}

	return &issuerpc.GetIssueResp{
		Id:                  issue.Id,
		Title:               issue.Title,
		Content:             issue.Content,
		Severity:            issue.Severity,
		Status:              issue.Status,
		AssignedTo:          issue.AssignedTo,
		Reporter:            issue.Reporter,
		Tester:              issue.Tester,
		Developer:           issue.Developer,
		ProductManager:      issue.ProductManager,
		AffectedVersion:     issue.AffectedVersion,
		FixVersion:          issue.FixVersion,
		Attachments:         issue.Attachments,
		Type:                issue.Type,
		ProcessPos:          issue.ProcessPos,
		ProcessStatus:       issue.ProcessStatus,
		ProcessApprover:     issue.ProcessApprover,
		ProcessApproverCode: issue.ProcessApproverCode,
		ProcessID:           issue.ProcessId,
		CreateAt:            issue.CreateAt,
	}, nil
}
