package logic

import (
	"context"
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/app/issuecenter/model"
)

type GetIssueProcessInfoLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetIssueProcessInfoLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetIssueProcessInfoLogic {
	return &GetIssueProcessInfoLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetIssueProcessInfoLogic) GetIssueProcessInfo(in *issuerpc.GetIssueProcessReq) (*issuerpc.IssueProcessInfo, error) {
	var issueProcess model.XIssuesProcess
	err := l.svcCtx.Db.QueryRow(&issueProcess, "SELECT * FROM x_issues_process WHERE id = ?", in.Id)
	if err != nil {
		l.Logger.Errorf("Failed to find issue process with ID %d, error: %v", in.Id, err)
		return nil, fmt.Errorf("failed to find issue process with ID %d: %v", in.Id, err)
	}

	return &issuerpc.IssueProcessInfo{
		Id:             issueProcess.Id,
		IssueId:        issueProcess.IssueId,
		Pos:            issueProcess.Pos,
		Approver:       issueProcess.Approver,
		ApproverCode:   issueProcess.ApproverCode,
		Status:         issueProcess.Status,
		ProcessHandler: issueProcess.ProcessHandler,
		Remark:         issueProcess.Remark,
		CreateAt:       issueProcess.CreateAt,
		Attachments:    issueProcess.Attachments,
		Tag:            issueProcess.Tag,
	}, nil
}
