package logic

import (
	"context"

	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type ListIssueProcessesLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewListIssueProcessesLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListIssueProcessesLogic {
	return &ListIssueProcessesLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *ListIssueProcessesLogic) ListIssueProcesses(req *issuerpc.ListIssueProcessRequest) (*issuerpc.ListIssueProcessResponse, error) {
	processes, err := l.svcCtx.IssueModel.ListIssueProcess(l.ctx, req.IssueId)
	if err != nil {
		l.Logger.Errorf("Failed to fetch issue processes: %v", err)
		return nil, err
	}

	respProcesses := make([]*issuerpc.IssueProcessInfo, len(processes))
	for i, process := range processes {
		respProcesses[i] = &issuerpc.IssueProcessInfo{
			Id:             process.Id,
			IssueId:        process.IssueId,
			Pos:            process.Pos,
			Approver:       process.Approver,
			ApproverCode:   process.ApproverCode,
			Status:         process.Status,
			ProcessHandler: process.ProcessHandler,
			Remark:         process.Remark,
			Attachments:    process.Attachments,
			Tag:            process.Tag,
			CreateAt:       process.CreateAt,
		}
	}

	return &issuerpc.ListIssueProcessResponse{
		Processes: respProcesses,
		Total:     int64(len(processes)),
	}, nil
}
