package logic

import (
	"context"
	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type ListIssuesLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewListIssuesLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListIssuesLogic {
	return &ListIssuesLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *ListIssuesLogic) ListIssues(req *issuerpc.ListIssueReq) (*issuerpc.ListIssueResp, error) {
	cond := map[string]interface{}{}
	if req.Status != 0 {
		cond["status"] = req.Status
	}
	if req.Title != "" {
		cond["title"] = req.Title
	}
	if req.Severity != "" {
		cond["severity"] = req.Severity
	}

	allIssues, count, err := l.svcCtx.IssueModel.List(l.ctx, cond, int(req.PageSize), int(req.Page-1)*int(req.PageSize))
	if err != nil {
		l.Logger.Errorf("Failed to fetch issues: %v", err)
		return nil, err
	}
	// 转换数据模型
	respIssues := make([]*issuerpc.IssueInfo, len(allIssues))
	for i, issue := range allIssues {
		respIssues[i] = &issuerpc.IssueInfo{
			Id:                  issue.Id,
			Title:               issue.Title,
			Content:             issue.Content,
			Severity:            issue.Severity,
			Status:              issue.Status,
			AssignedTo:          issue.AssignedTo,
			Reporter:            issue.Reporter,
			Tester:              issue.Tester,
			Developer:           issue.Developer,
			ProductManager:      issue.ProductManager,
			AffectedVersion:     issue.AffectedVersion,
			FixVersion:          issue.FixVersion,
			Attachments:         issue.Attachments,
			Type:                issue.Type,
			ProcessPos:          issue.ProcessPos,
			ProcessStatus:       issue.ProcessStatus,
			ProcessApprover:     issue.ProcessApprover,
			ProcessApproverCode: issue.ProcessApproverCode,
			ProcessID:           issue.ProcessId,
			CreateAt:            issue.CreateAt,
		}
	}
	return &issuerpc.ListIssueResp{
		Issues: respIssues,
		Total:  count,
	}, nil
}
