package logic

import (
	"context"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type MyDonedLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewMyDonedLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MyDonedLogic {
	return &MyDonedLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *MyDonedLogic) MyDoned(in *issuerpc.MyDoneReq) (*issuerpc.ListIssueResp, error) {
	allIssues, count, err := l.svcCtx.IssueModel.MyDoneList(l.ctx, in.Email, int(in.PageSize), int(in.Page-1)*int(in.PageSize))
	if err != nil {
		l.Logger.Errorf("Failed to fetch issues: %v", err)
		return nil, err
	}
	// 转换数据模型
	respIssues := make([]*issuerpc.IssueInfo, len(allIssues))
	for i, issue := range allIssues {
		respIssues[i] = &issuerpc.IssueInfo{
			Id:                  issue.Id,
			Title:               issue.Title,
			Content:             issue.Content,
			Severity:            issue.Severity,
			Status:              issue.Status,
			AssignedTo:          issue.AssignedTo,
			Reporter:            issue.Reporter,
			Tester:              issue.Tester,
			Developer:           issue.Developer,
			ProductManager:      issue.ProductManager,
			AffectedVersion:     issue.AffectedVersion,
			FixVersion:          issue.FixVersion,
			Attachments:         issue.Attachments,
			Type:                issue.Type,
			ProcessPos:          issue.ProcessPos,
			ProcessStatus:       issue.ProcessStatus,
			ProcessApprover:     issue.ProcessApprover,
			ProcessApproverCode: issue.ProcessApproverCode,
			ProcessID:           issue.ProcessId,
			CreateAt:            issue.CreateAt,
		}
	}
	return &issuerpc.ListIssueResp{
		Issues: respIssues,
		Total:  count,
	}, nil
}
