package logic

import (
	"context"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type MyFollowLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewMyFollowLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MyFollowLogic {
	return &MyFollowLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *MyFollowLogic) MyFollow(in *issuerpc.MyDoneReq) (*issuerpc.ListIssueResp, error) {
	var offset uint64
	var page uint64

	if in.Page < 1 {
		page = 1
	} else {
		page = in.Page
	}
	offset = (page - 1) * in.PageSize
	total, data, err := l.svcCtx.UserFollowIssueModel.FindOneByUidAndIssueId(l.ctx, in.Email, offset, in.PageSize)
	if err != nil {
		l.Logger.Errorf("Failed to fetch issues: %v", err)
		return nil, err
	}
	listIssue := make([]*issuerpc.IssueInfo, 0)

	for _, item := range *data {
		var issue issuerpc.IssueInfo
		_ = copier.Copy(&issue, item)
		listIssue = append(listIssue, &issue)
	}
	return &issuerpc.ListIssueResp{
		Issues: listIssue,
		Total:  total,
	}, err
}
