package logic

import (
	"context"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type MySubmitLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewMySubmitLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MySubmitLogic {
	return &MySubmitLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *MySubmitLogic) MySubmit(in *issuerpc.MyListIssueReq) (*issuerpc.ListIssueResp, error) {
	cond := map[string]interface{}{}
	if in.Status != 0 {
		cond["status"] = in.Status
	}
	if in.Title != "" {
		cond["title"] = in.Title
	}
	if in.Severity != "" {
		cond["severity"] = in.Severity
	}

	allIssues, count, err := l.svcCtx.IssueModel.MySubmitList(l.ctx, cond, int(in.PageSize), int(in.Page-1)*int(in.PageSize), in.Email)
	if err != nil {
		l.Logger.Errorf("Failed to fetch issues: %v", err)
		return nil, err
	}
	// 转换数据模型
	respIssues := make([]*issuerpc.IssueInfo, len(allIssues))
	for i, issue := range allIssues {
		respIssues[i] = &issuerpc.IssueInfo{
			Id:                  issue.Id,
			Title:               issue.Title,
			Content:             issue.Content,
			Severity:            issue.Severity,
			Status:              issue.Status,
			AssignedTo:          issue.AssignedTo,
			Reporter:            issue.Reporter,
			Tester:              issue.Tester,
			Developer:           issue.Developer,
			ProductManager:      issue.ProductManager,
			AffectedVersion:     issue.AffectedVersion,
			FixVersion:          issue.FixVersion,
			Attachments:         issue.Attachments,
			Type:                issue.Type,
			ProcessPos:          issue.ProcessPos,
			ProcessStatus:       issue.ProcessStatus,
			ProcessApprover:     issue.ProcessApprover,
			ProcessApproverCode: issue.ProcessApproverCode,
			ProcessID:           issue.ProcessId,
			CreateAt:            issue.CreateAt,
		}
	}
	return &issuerpc.ListIssueResp{
		Issues: respIssues,
		Total:  count,
	}, nil
}
