package logic

import (
	"context"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type MyWorkbenchLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewMyWorkbenchLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MyWorkbenchLogic {
	return &MyWorkbenchLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *MyWorkbenchLogic) MyWorkbench(in *issuerpc.MyWorkbenchReq) (*issuerpc.MyWorkbenchRep, error) {
	//
	data, err := l.svcCtx.UserFollowIssueModel.CountMyWorkbench(l.ctx, in.Email)
	if err != nil {
		l.Logger.Errorf("Failed to fetch issues: %v", err)
		return nil, err
	}
	resp := issuerpc.MyWorkbenchRep{}
	resp.Data = data
	return &resp, nil
}
