package logic

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/sqlx"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type SoftDeleteIssueLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewSoftDeleteIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *SoftDeleteIssueLogic {
	return &SoftDeleteIssueLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *SoftDeleteIssueLogic) SoftDeleteIssue(in *issuerpc.SoftDeleteIssueReq) (*issuerpc.SoftDeleteIssueResp, error) {
	l.Logger.Infof("Soft deleting issue with ID: %d", in.IssueId)

	err := l.svcCtx.Db.Transact(func(session sqlx.Session) error {
		softDeleteQuery := `UPDATE x_issues SET is_deleted = 1 WHERE id = ?`

		_, err := session.ExecCtx(l.ctx, softDeleteQuery, in.IssueId)
		if err != nil {
			l.Logger.Errorf("Error while soft deleting issue: %v", err)
			return err
		}
		return nil
	})

	if err != nil {
		return nil, err
	}
	return &issuerpc.SoftDeleteIssueResp{
		IssueId: in.IssueId,
	}, nil
}
