package logic

import (
	"context"
	"time"

	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issuerpc/internal/svc"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
	"oa-server/app/issuecenter/model"
)

type UpdateIssueLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdateIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateIssueLogic {
	return &UpdateIssueLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *UpdateIssueLogic) UpdateIssue(in *issuerpc.UpdateIssueReq) (*issuerpc.UpdateIssueResp, error) {
	issueData := &model.XIssues{
		Id:              in.Id,
		Title:           in.Title,
		Content:         in.Content,
		Severity:        in.Severity,
		Status:          in.Status,
		AssignedTo:      in.AssignedTo,
		Reporter:        in.Reporter,
		Tester:          in.Tester,
		Developer:       in.Developer,
		ProductManager:  in.ProductManager,
		AffectedVersion: in.AffectedVersion,
		FixVersion:      in.FixVersion,
		Attachments:     in.Attachments,
		Type:            in.Type,
		UpdateAt:        time.Now().Unix(),
	}

	err := l.svcCtx.IssueModel.UpdateIssue(l.ctx, issueData)
	if err != nil {
		l.Logger.Errorf("Failed to update issue with ID %d, error: %v", in.Id, err)
		return nil, err
	}

	return &issuerpc.UpdateIssueResp{Id: in.Id}, nil
}
