package svc

import (
	"oa-server/common/msgcenter"

	"github.com/zeromicro/go-zero/core/logx"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/redis"
	"github.com/zeromicro/go-zero/core/stores/sqlx"

	"oa-server/app/issuecenter/issuerpc/internal/config"
	"oa-server/app/issuecenter/model"
)

type ServiceContext struct {
	Config               config.Config
	RedisClient          *redis.Redis
	IssueModel           model.XIssuesModel // 新增微服务需要新配置
	UserFollowIssueModel model.XUserFollowIssueModel
	Db                   sqlx.SqlConn
	LarkService          *msgcenter.LarkService
}

func NewServiceContext(c config.Config) *ServiceContext {
	larkService, err := msgcenter.NewLarkService(c.Lark)
	if err != nil {
		logx.Errorf("Failed to initialize Lark service: %v", err)
		return nil
	}
	var nodeConfs []cache.NodeConf
	for _, node := range c.Cache {
		nodeConf := cache.NodeConf{
			RedisConf: redis.RedisConf{
				Host: node.Host,
				Type: node.Type,
				Pass: node.Pass,
			},
			Weight: node.Weight,
		}
		nodeConfs = append(nodeConfs, nodeConf)
	}

	// 新增微服务需要新配置
	sqlConn := sqlx.NewMysql(c.DB.DataSource)
	return &ServiceContext{
		Config: c,
		RedisClient: redis.New(c.Redis.Host, func(r *redis.Redis) {
			r.Type = c.Redis.Type
			r.Pass = c.Redis.Pass
		}),
		IssueModel:           model.NewXIssuesModel(sqlConn, nodeConfs), // 新增微服务需要新配置
		UserFollowIssueModel: model.NewXUserFollowIssueModel(sqlConn),
		Db:                   sqlConn,
		LarkService:          larkService,
	}
}
