// Code generated by goctl. DO NOT EDIT.

package model

import (
	"context"
	"database/sql"
	"fmt"
	"strings"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlc"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xIssuesFieldNames          = builder.RawFieldNames(&XIssues{})
	xIssuesRows                = strings.Join(xIssuesFieldNames, ",")
	xIssuesRowsExpectAutoSet   = strings.Join(stringx.Remove(xIssuesFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xIssuesRowsWithPlaceHolder = strings.Join(stringx.Remove(xIssuesFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	cacheXIssuesIdPrefix = "cache:xIssues:id:"
)

type (
	xIssuesModel interface {
		Insert(ctx context.Context, data *XIssues) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XIssues, error)
		Update(ctx context.Context, data *XIssues) error
		Delete(ctx context.Context, id int64) error
		UpdateIssue(ctx context.Context, data *XIssues) error
		List(ctx context.Context, cond map[string]interface{}, limit, offset int) ([]*XIssues,int64, error)
		ListIssueProcess(ctx context.Context, issueId int64) ([]*XIssuesProcess, error)
		MySubmitList(ctx context.Context, cond map[string]interface{}, limit, offset int, email string) ([]*XIssues,int64, error)
		MyHandleList(ctx context.Context, email string, limit, offset int) ([]XIssues, int64, error)
		MyDoneList(ctx context.Context, email string, limit, offset int) ([]XIssues, int64, error)
		HandleProcess(ctx context.Context, email, approver, attachments, tag, remark string, issue_id, pos, handleStatus, estimatedTime int64) error
	}

	defaultXIssuesModel struct {
		sqlc.CachedConn
		table string
	}

	XIssues struct {
		Id                  int64  `db:"id"`                    // 主键
		Title               string `db:"title"`                 // 标题
		Content             string `db:"content"`               // 内容
		Severity            string `db:"severity"`              // 严重程度
		Status              int64  `db:"status"`                // 流程状态
		ProcessPos          int64  `db:"process_pos"`           // 当前流程位置
		ProcessId           int64  `db:"process_id"`            // 当前处理流程id
		ProcessStatus       int64  `db:"process_status"`        // 当前处理状态
		AssignedTo          string `db:"assigned_to"`           // 分配给
		Reporter            string `db:"reporter"`              // 提交人
		Tester              string `db:"tester"`                // 负责测试
		Developer           string `db:"developer"`             // 负责研发
		ProductManager      string `db:"product_manager"`       // 负责产品
		ProcessApprover     string `db:"process_approver"`      // 当前d
		ProcessApproverCode int64  `db:"process_approver_code"` // 当前处理角色
		AffectedVersion     string `db:"affected_version"`      // 影响版本
		FixVersion          string `db:"fix_version"`           // 修复版本
		Attachments         string `db:"attachments"`           // 附件
		Labels              string `db:"labels"`                // 标签
		Type                int64  `db:"type"`                  // 1: issue
		CreateAt            int64  `db:"create_at"`             // 创建时间
		UpdateAt            int64  `db:"update_at"`             // 更新时间
		IsDeleted           int64  `db:"is_deleted"`            // 0-1-
		EstimatedTime       int64  `db:"estimated_time"`        // 预计时间
	}
)

func newXIssuesModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) *defaultXIssuesModel {
	return &defaultXIssuesModel{
		CachedConn: sqlc.NewConn(conn, c, opts...),
		table:      "`x_issues`",
	}
}

func (m *defaultXIssuesModel) Delete(ctx context.Context, id int64) error {
	xIssuesIdKey := fmt.Sprintf("%s%v", cacheXIssuesIdPrefix, id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
		return conn.ExecCtx(ctx, query, id)
	}, xIssuesIdKey)
	return err
}

func (m *defaultXIssuesModel) FindOne(ctx context.Context, id int64) (*XIssues, error) {
	xIssuesIdKey := fmt.Sprintf("%s%v", cacheXIssuesIdPrefix, id)
	var resp XIssues
	err := m.QueryRowCtx(ctx, &resp, xIssuesIdKey, func(ctx context.Context, conn sqlx.SqlConn, v any) error {
		query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xIssuesRows, m.table)
		return conn.QueryRowCtx(ctx, v, query, id)
	})
	switch err {
	case nil:
		return &resp, nil
	case sqlc.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXIssuesModel) Insert(ctx context.Context, data *XIssues) (sql.Result, error) {
	xIssuesIdKey := fmt.Sprintf("%s%v", cacheXIssuesIdPrefix, data.Id)
	ret, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xIssuesRowsExpectAutoSet)
		return conn.ExecCtx(ctx, query, data.Title, data.Content, data.Severity, data.Status, data.ProcessPos, data.ProcessId, data.ProcessStatus, data.AssignedTo, data.Reporter, data.Tester, data.Developer, data.ProductManager, data.ProcessApprover, data.ProcessApproverCode, data.AffectedVersion, data.FixVersion, data.Attachments, data.Labels, data.Type, data.IsDeleted, data.EstimatedTime)
	}, xIssuesIdKey)
	return ret, err
}

func (m *defaultXIssuesModel) Update(ctx context.Context, data *XIssues) error {
	xIssuesIdKey := fmt.Sprintf("%s%v", cacheXIssuesIdPrefix, data.Id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xIssuesRowsWithPlaceHolder)
		return conn.ExecCtx(ctx, query, data.Title, data.Content, data.Severity, data.Status, data.ProcessPos, data.ProcessId, data.ProcessStatus, data.AssignedTo, data.Reporter, data.Tester, data.Developer, data.ProductManager, data.ProcessApprover, data.ProcessApproverCode, data.AffectedVersion, data.FixVersion, data.Attachments, data.Labels, data.Type, data.IsDeleted, data.EstimatedTime, data.Id)
	}, xIssuesIdKey)
	return err
}

func (m *defaultXIssuesModel) formatPrimary(primary any) string {
	return fmt.Sprintf("%s%v", cacheXIssuesIdPrefix, primary)
}

func (m *defaultXIssuesModel) queryPrimary(ctx context.Context, conn sqlx.SqlConn, v, primary any) error {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xIssuesRows, m.table)
	return conn.QueryRowCtx(ctx, v, query, primary)
}

func (m *defaultXIssuesModel) tableName() string {
	return m.table
}
