package model

import (
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XIssuesProcessModel = (*customXIssuesProcessModel)(nil)

type (
	// XIssuesProcessModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXIssuesProcessModel.
	XIssuesProcessModel interface {
		xIssuesProcessModel
	}

	customXIssuesProcessModel struct {
		*defaultXIssuesProcessModel
	}
)

// NewXIssuesProcessModel returns a model for the database table.
func NewXIssuesProcessModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) XIssuesProcessModel {
	return &customXIssuesProcessModel{
		defaultXIssuesProcessModel: newXIssuesProcessModel(conn, c, opts...),
	}
}
