// Code generated by goctl. DO NOT EDIT.

package model

import (
	"context"
	"database/sql"
	"fmt"
	"strings"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlc"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xIssuesProcessFieldNames          = builder.RawFieldNames(&XIssuesProcess{})
	xIssuesProcessRows                = strings.Join(xIssuesProcessFieldNames, ",")
	xIssuesProcessRowsExpectAutoSet   = strings.Join(stringx.Remove(xIssuesProcessFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xIssuesProcessRowsWithPlaceHolder = strings.Join(stringx.Remove(xIssuesProcessFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	cacheXIssuesProcessIdPrefix = "cache:xIssuesProcess:id:"
)

type (
	xIssuesProcessModel interface {
		Insert(ctx context.Context, data *XIssuesProcess) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XIssuesProcess, error)
		Update(ctx context.Context, data *XIssuesProcess) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXIssuesProcessModel struct {
		sqlc.CachedConn
		table string
	}

	XIssuesProcess struct {
		Id             int64  `db:"id"`              // 对象Id
		IssueId        int64  `db:"issue_id"`        // issue id
		Pos            int64  `db:"pos"`             // 流程当前步骤
		Approver       string `db:"approver"`        // 处理人
		Attachments    string `db:"attachments"`     // 附件
		ApproverCode   int64  `db:"approver_code"`   // 处理人类型 1 开发 2 开发组长 3 测试 4 测试组长 5 运维 6 项目发布 100 流程结束
		Status         int64  `db:"status"`          // 流程状态
		ProcessHandler string `db:"process_handler"` // 流程处理人
		Remark         string `db:"remark"`          // 处理备注
		Tag            string `db:"tag"`             // 标签
		CreateAt       int64  `db:"create_at"`       // 创建时间
		UpdateAt       int64  `db:"update_at"`       // 更新时间
		EstimatedTime  int64  `db:"estimated_time"`  // 预计处理时间
	}
)

func newXIssuesProcessModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) *defaultXIssuesProcessModel {
	return &defaultXIssuesProcessModel{
		CachedConn: sqlc.NewConn(conn, c, opts...),
		table:      "`x_issues_process`",
	}
}

func (m *defaultXIssuesProcessModel) Delete(ctx context.Context, id int64) error {
	xIssuesProcessIdKey := fmt.Sprintf("%s%v", cacheXIssuesProcessIdPrefix, id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
		return conn.ExecCtx(ctx, query, id)
	}, xIssuesProcessIdKey)
	return err
}

func (m *defaultXIssuesProcessModel) FindOne(ctx context.Context, id int64) (*XIssuesProcess, error) {
	xIssuesProcessIdKey := fmt.Sprintf("%s%v", cacheXIssuesProcessIdPrefix, id)
	var resp XIssuesProcess
	err := m.QueryRowCtx(ctx, &resp, xIssuesProcessIdKey, func(ctx context.Context, conn sqlx.SqlConn, v any) error {
		query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xIssuesProcessRows, m.table)
		return conn.QueryRowCtx(ctx, v, query, id)
	})
	switch err {
	case nil:
		return &resp, nil
	case sqlc.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXIssuesProcessModel) Insert(ctx context.Context, data *XIssuesProcess) (sql.Result, error) {
	xIssuesProcessIdKey := fmt.Sprintf("%s%v", cacheXIssuesProcessIdPrefix, data.Id)
	ret, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xIssuesProcessRowsExpectAutoSet)
		return conn.ExecCtx(ctx, query, data.IssueId, data.Pos, data.Approver, data.Attachments, data.ApproverCode, data.Status, data.ProcessHandler, data.Remark, data.Tag)
	}, xIssuesProcessIdKey)
	return ret, err
}

func (m *defaultXIssuesProcessModel) Update(ctx context.Context, data *XIssuesProcess) error {
	xIssuesProcessIdKey := fmt.Sprintf("%s%v", cacheXIssuesProcessIdPrefix, data.Id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xIssuesProcessRowsWithPlaceHolder)
		return conn.ExecCtx(ctx, query, data.IssueId, data.Pos, data.Approver, data.Attachments, data.ApproverCode, data.Status, data.ProcessHandler, data.Remark, data.Tag, data.Id)
	}, xIssuesProcessIdKey)
	return err
}

func (m *defaultXIssuesProcessModel) formatPrimary(primary any) string {
	return fmt.Sprintf("%s%v", cacheXIssuesProcessIdPrefix, primary)
}

func (m *defaultXIssuesProcessModel) queryPrimary(ctx context.Context, conn sqlx.SqlConn, v, primary any) error {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xIssuesProcessRows, m.table)
	return conn.QueryRowCtx(ctx, v, query, primary)
}

func (m *defaultXIssuesProcessModel) tableName() string {
	return m.table
}
