package model

import "github.com/zeromicro/go-zero/core/stores/sqlx"

var _ XUserFollowIssueModel = (*customXUserFollowIssueModel)(nil)

type (
	// XUserFollowIssueModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXUserFollowIssueModel.
	XUserFollowIssueModel interface {
		xUserFollowIssueModel
		withSession(session sqlx.Session) XUserFollowIssueModel
	}

	customXUserFollowIssueModel struct {
		*defaultXUserFollowIssueModel
	}
)

// NewXUserFollowIssueModel returns a model for the database table.
func NewXUserFollowIssueModel(conn sqlx.SqlConn) XUserFollowIssueModel {
	return &customXUserFollowIssueModel{
		defaultXUserFollowIssueModel: newXUserFollowIssueModel(conn),
	}
}

func (m *customXUserFollowIssueModel) withSession(session sqlx.Session) XUserFollowIssueModel {
	return NewXUserFollowIssueModel(sqlx.NewSqlConnFromSession(session))
}
