// Code generated by goctl. DO NOT EDIT.

package model

import (
	"context"
	"database/sql"
	"fmt"
	"strings"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xUserFollowIssueFieldNames          = builder.RawFieldNames(&XUserFollowIssue{})
	xUserFollowIssueRows                = strings.Join(xUserFollowIssueFieldNames, ",")
	xUserFollowIssueRowsExpectAutoSet   = strings.Join(stringx.Remove(xUserFollowIssueFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xUserFollowIssueRowsWithPlaceHolder = strings.Join(stringx.Remove(xUserFollowIssueFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xUserFollowIssueModel interface {
		Insert(ctx context.Context, data *XUserFollowIssue) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XUserFollowIssue, error)
		Update(ctx context.Context, data *XUserFollowIssue) error
		Delete(ctx context.Context, id uint64) error
		DeleteByEmailAndIssueId(ctx context.Context, email string, issueId uint64) error
		// 两表联查
		FindOneByUidAndIssueId(ctx context.Context, email string, offset, limit uint64) (int64, *[]XIssues, error)
		// 我的工作台数量
		CountMyWorkbench(ctx context.Context, email string) ([]int64, error)
	}

	defaultXUserFollowIssueModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XUserFollowIssue struct {
		Id      uint64 `db:"id"` // 主键id
		Email   string `db:"email"`
		IssueId uint64 `db:"issue_id"`
	}
)

func newXUserFollowIssueModel(conn sqlx.SqlConn) *defaultXUserFollowIssueModel {
	return &defaultXUserFollowIssueModel{
		conn:  conn,
		table: "`x_user_follow_issue`",
	}
}

func (m *defaultXUserFollowIssueModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXUserFollowIssueModel) FindOne(ctx context.Context, id uint64) (*XUserFollowIssue, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xUserFollowIssueRows, m.table)
	var resp XUserFollowIssue
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXUserFollowIssueModel) Insert(ctx context.Context, data *XUserFollowIssue) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?)", m.table, xUserFollowIssueRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.Email, data.IssueId)
	return ret, err
}

func (m *defaultXUserFollowIssueModel) Update(ctx context.Context, data *XUserFollowIssue) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xUserFollowIssueRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.Email, data.IssueId, data.Id)
	return err
}


func (m *defaultXUserFollowIssueModel) DeleteByEmailAndIssueId(ctx context.Context, email string, issueId uint64) error {
	query := fmt.Sprintf("delete from %s where `email` = ? and `issue_id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, email, issueId)
	return err
}

func (m *defaultXUserFollowIssueModel) FindOneByUidAndIssueId(ctx context.Context, email string, offset, limit uint64) (int64, *[]XIssues, error) {
	query := fmt.Sprintf("select count(*) from %s where `email` = ?", m.table)
	var total int64 = 0
	err := m.conn.QueryRowCtx(ctx, &total, query, email)
	if total == 0 {
		return 0, &[]XIssues{}, nil
	}
	if err != nil {
		return 0, &[]XIssues{}, nil
	}
    query = `SELECT x_issues.* FROM x_issues INNER JOIN x_user_follow_issue ON x_issues.id = x_user_follow_issue.issue_id WHERE x_user_follow_issue.email = ? ORDER BY x_issues.id DESC LIMIT ? OFFSET ?`
    var resp []XIssues
    err = m.conn.QueryRowsCtx(ctx, &resp, query, email, limit, offset)
	if err == sql.ErrNoRows {
		return 0, &[]XIssues{}, nil
	}
    if err != nil {
        return 0, nil, err
    }

    return total, &resp, nil
}

func(m *defaultXUserFollowIssueModel) CountMyWorkbench(ctx context.Context, email string) ([]int64, error) {
	query := fmt.Sprintf("SELECT COUNT(*) FROM %s WHERE `email` = ?", m.table)
	var total int64
	total = 0
	m.conn.QueryRowCtx(ctx, &total, query, email)
	var mySubmitTotal int64
	mySubmitTotal = 0
	var myHandleSubmitTotal int64
	myHandleSubmitTotal = 0
	var myDoneTotal int64
	myDoneTotal = 0
	query = `SELECT COUNT(*) FROM x_issues WHERE reporter = ?`
	m.conn.QueryRowCtx(ctx, &mySubmitTotal, query, email)
	// query = `select count(*) from x_issues_process where approver = ? and status = 1`
	query = "select count(*) from x_issues where `process_approver` = ? and status = 1"
	m.conn.QueryRowCtx(ctx, &myHandleSubmitTotal, query, email)
	// query = `SELECT COUNT(DISTINCT issue_id) FROM x_issues_process WHERE approver = ? AND status > 1`
	query = `
		SELECT COUNT(DISTINCT xip.issue_id) AS unique_issue_count
        FROM x_issues_process xip
        JOIN x_issues xi ON xip.issue_id = xi.id
        WHERE xip.approver = ? AND xip.status > 1 AND xi.status > 1;`
	m.conn.QueryRowCtx(ctx, &myDoneTotal, query, email)
	// 我的待办 + 我的已办 + 我的关注 + 我的创建
	return []int64{myHandleSubmitTotal, myDoneTotal, total, mySubmitTotal}, nil
}

func (m *defaultXUserFollowIssueModel) tableName() string {
	return m.table
}
