package logic

import (
	"context"
	"github.com/hibiken/asynq"
	"oa-server/app/jobcenter/cmd/task/internal/svc"
	"oa-server/app/jobcenter/cmd/task/tasktype"
)

type CronJob struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCronJob(ctx context.Context, svcCtx *svc.ServiceContext) *CronJob {
	return &CronJob{
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

// Register register job
func (l *CronJob) Register() *asynq.ServeMux {
	mux := asynq.NewServeMux()
	demo := NewDemoHandler(l.svcCtx)
	mux.HandleFunc(tasktype.ScheduleDemo, demo.BizTaskFunc) // demo task  注册
	//mux.Handle(tasktype.ScheduleSettleRecord, NewSettleRecordHandler(l.svcCtx))

	return mux
}