package main

import (
	"context"
	"flag"
	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/jobcenter/cmd/task/internal/config"
	"oa-server/app/jobcenter/cmd/task/internal/logic"
	"oa-server/app/jobcenter/cmd/task/internal/svc"
	"os"

	"github.com/zeromicro/go-zero/core/conf"
)

var configFile = flag.String("f", "app/jobcenter/cmd/task/etc/task.yaml", "Specify the config file")

func main() {
	flag.Parse()
	var c config.Config

	conf.MustLoad(*configFile, &c, conf.UseEnv())

	if err := c.SetUp(); err != nil {
		panic(err)
	}

	logx.DisableStat()

	svcContext := svc.NewServiceContext(c)
	ctx := context.Background()
	cronJob := logic.NewCronJob(ctx, svcContext)
	mux := cronJob.Register() // 注册路由程序

	if err := svcContext.AsynqServer.Run(mux); err != nil {
		logx.WithContext(ctx).Errorf("CronJobErr run err:%+v", err)
		os.Exit(1)
	}
}