package model

import (
	"time"
)

type UserRole int

const (
	RoleUnknown UserRole = iota + 1
	RoleDeveloper
	RoleTester
	RoleProduct
	RoleOps
)

// UserInfo 用户信息
type UserInfo struct {
	ID                   int64    `json:"id"`
	Username             string   `json:"username"`
	NickName             string   `json:"nickName"`
	LarkUserId           string   `json:"larkUserId"`
	LarkHeaderImg        string   `json:"larkHeaderImg"`
	Email                string   `json:"email"`
	UserRole             UserRole `json:"user_role"`
	LeaderEmail          string   `json:"leader_email"`
	JobKey               string   `json:"job_key"`
	JobName              string   `json:"job_name"`
	DepartmentKeyList    []string `json:"department_key_list"`
	DepartmentList       []Dept   `json:"department_list"`
	Creator              string   `json:"creator"`
	Enable               int      `json:"enable"`
	CreatedAtStr         string   `json:"created_at_str"`
	OwnerDepartmentList  []Dept   `json:"owner_department_list"`
	SecondDepartmentList []Dept   `json:"second_department_list"`
	JoinTime             int64    `json:"join_time"`
	LeaveTime            int64    `json:"leave_time"`
	UserStatus           int      `json:"user_status"`
}

// Dept 部门信息
type Dept struct {
	DepartmentKey  string `json:"department_key"`
	DepartmentName string `json:"department_name"`
}

// DepartmentInfo 部门信息
type DepartmentInfo struct {
	ID                   int      `json:"id"`
	DepartmentName       string   `json:"department_name"`
	DepartmentKey        string   `json:"department_key"`
	ParentDepartmentKey  string   `json:"parent_department_key"`
	ParentDepartmentName string   `json:"parent_department_name"`
	Owner                string   `json:"owner"`
	Enable               int      `json:"enable"`
	Creator              string   `json:"creator"`
	CreateAtStr          string   `json:"create_at_str"`
	UserRole             UserRole `json:"user_role"`
}

// UserCenterData 用户中心数据
type UserCenterData struct {
	Users       []UserInfo       `json:"users"`
	Departments []DepartmentInfo `json:"departments"`
	UpdateTime  time.Time        `json:"update_time"`
}

// UserListResp 用户列表响应
type UserListResp struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		List     []UserInfo `json:"list"`
		Total    int        `json:"total"`
		PageNum  int        `json:"pageNum"`
		PageSize int        `json:"pageSize"`
	} `json:"data"`
}

// DepartmentListResp 部门列表响应
type DepartmentListResp struct {
	Code    int              `json:"code"`
	Message string           `json:"message"`
	Data    []DepartmentInfo `json:"data"`
}
