### 1. "创建okr"

1. route definition

- Url: /kpicenter/v1/okr/create
- Method: POST
- Request: `CreateOkrReq`
- Response: `SuccessResp`

2. request definition



```golang
type CreateOkrReq struct {
	DateStr string `json:"dateStr"` // 日期
	Data []OkrData `json:"data"` // 数据
}
```


3. response definition



```golang
type SuccessResp struct {
	Success bool `json:"success"`
}
```

### 2. "删除某个okr"

1. route definition

- Url: /kpicenter/v1/okr/delete
- Method: POST
- Request: `IDReq`
- Response: `SuccessResp`

2. request definition



```golang
type IDReq struct {
	ID uint64 `json:"id"` // id
}
```


3. response definition



```golang
type SuccessResp struct {
	Success bool `json:"success"`
}
```

### 3. "获取okr列表"

1. route definition

- Url: /kpicenter/v1/okr/list
- Method: POST
- Request: `OkrListReq`
- Response: `OkrListResp`

2. request definition



```golang
type OkrListReq struct {
	Page uint64 `json:"page"`
	PageSize uint64 `json:"pageSize"`
	DateStr string `json:"dateStr"` // 日期
}

type PageReq struct {
	Page uint64 `json:"page"`
	PageSize uint64 `json:"pageSize"`
}
```


3. response definition



```golang
type OkrListResp struct {
	Total int64 `json:"total"`
	List []OkrDetailResp `json:"list"`
}
```

### 4. "更新okr"

1. route definition

- Url: /kpicenter/v1/okr/update
- Method: POST
- Request: `UpOkrReq`
- Response: `SuccessResp`

2. request definition



```golang
type UpOkrReq struct {
	ID uint64 `json:"id"` // id
	Target string `json:"target"` // 目标
	Result string `json:"result"` // 结果
	Quantification string `json:"quantification"` // 量化
}

type OkrData struct {
	Target string `json:"target"` // 目标
	Result string `json:"result"` // 结果
	Quantification string `json:"quantification"` // 量化
}
```


3. response definition



```golang
type SuccessResp struct {
	Success bool `json:"success"`
}
```

### 5. "创建复盘"

1. route definition

- Url: /kpicenter/v1/review/add
- Method: POST
- Request: `AddReviewReq`
- Response: `Response`

2. request definition



```golang
type AddReviewReq struct {
	Level string `json:"level"` // 故障定级
	Scope string `json:"scope"` // 影响范围
	Review string `json:"review"` // 回顾
	RootCause string `json:"rootCause"` // 故障根因
	Scheme string `json:"scheme"` // 修复方案
	Improvement string `json:"improvement"` // 改进方案
	Kpi string `json:"kpi"` // 关联绩效
	Remark string `json:"remark"` // 备注
	IssueID uint64 `json:"issueID"` // 关联的issueid
	Users string `json:"users"` // 邀请的用户
}
```


3. response definition



```golang
type Response struct {
	Message string `json:"message"`
}
```

### 6. "获取复盘详情"

1. route definition

- Url: /kpicenter/v1/review/detail
- Method: POST
- Request: `IDReq`
- Response: `ReviewDetailResp`

2. request definition



```golang
type IDReq struct {
	ID uint64 `json:"id"` // id
}
```


3. response definition



```golang
type ReviewDetailResp struct {
	ID uint64 `json:"id"` // id
	Level string `json:"level"` // 故障定级
	Scope string `json:"scope"` // 影响范围
	Review string `json:"review"` // 回顾
	RootCause string `json:"rootCause"` // 故障根因
	Scheme string `json:"scheme"` // 修复方案
	Improvement string `json:"improvement"` // 改进方案
	Kpi string `json:"kpi"` // 关联绩效
	Remark string `json:"remark"` // 备注
	IssueID uint64 `json:"issueID"` // 关联的issueid
	Users string `json:"users"` // 邀请的用户
	Owner string `json:"owner"` // 创建人
	CreatedAt string `json:"createdAt"` // 创建时间
	UpdatedAt string `json:"updatedAt"` // 更新时间
}

type UpReviewReq struct {
	ID uint64 `json:"id"` // id
	Level string `json:"level"` // 故障定级
	Scope string `json:"scope"` // 影响范围
	Review string `json:"review"` // 回顾
	RootCause string `json:"rootCause"` // 故障根因
	Scheme string `json:"scheme"` // 修复方案
	Improvement string `json:"improvement"` // 改进方案
	Kpi string `json:"kpi"` // 关联绩效
	Remark string `json:"remark"` // 备注
	IssueID uint64 `json:"issueID"` // 关联的issueid
	Users string `json:"users"` // 邀请的用户
}

type AddReviewReq struct {
}
```

### 7. "获取复盘列表"

1. route definition

- Url: /kpicenter/v1/review/list
- Method: POST
- Request: `PageReq`
- Response: `ReviewListResp`

2. request definition



```golang
type PageReq struct {
	Page uint64 `json:"page"`
	PageSize uint64 `json:"pageSize"`
}
```


3. response definition



```golang
type ReviewListResp struct {
	Total int64 `json:"total"`
	List []ReviewDetailResp `json:"list"`
}
```

### 8. "更新复盘"

1. route definition

- Url: /kpicenter/v1/review/update
- Method: POST
- Request: `UpReviewReq`
- Response: `Response`

2. request definition



```golang
type UpReviewReq struct {
	ID uint64 `json:"id"` // id
	Level string `json:"level"` // 故障定级
	Scope string `json:"scope"` // 影响范围
	Review string `json:"review"` // 回顾
	RootCause string `json:"rootCause"` // 故障根因
	Scheme string `json:"scheme"` // 修复方案
	Improvement string `json:"improvement"` // 改进方案
	Kpi string `json:"kpi"` // 关联绩效
	Remark string `json:"remark"` // 备注
	IssueID uint64 `json:"issueID"` // 关联的issueid
	Users string `json:"users"` // 邀请的用户
}

type AddReviewReq struct {
	Level string `json:"level"` // 故障定级
	Scope string `json:"scope"` // 影响范围
	Review string `json:"review"` // 回顾
	RootCause string `json:"rootCause"` // 故障根因
	Scheme string `json:"scheme"` // 修复方案
	Improvement string `json:"improvement"` // 改进方案
	Kpi string `json:"kpi"` // 关联绩效
	Remark string `json:"remark"` // 备注
	IssueID uint64 `json:"issueID"` // 关联的issueid
	Users string `json:"users"` // 邀请的用户
}
```


3. response definition



```golang
type Response struct {
	Message string `json:"message"`
}
```

