package okr

import (
	"net/http"

	"oa-server/common/result"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/kpicenter/kpi_api/internal/logic/okr"
	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
)

func CreateOkrHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CreateOkrReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := okr.NewCreateOkrLogic(r.Context(), svcCtx)
		resp, err := l.CreateOkr(&req)
		result.HttpResult(r, w, resp, err)
	}
}
