package review

import (
	"net/http"
	"oa-server/common/result"

	"oa-server/app/kpicenter/kpi_api/internal/logic/review"
	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func AddReviewHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.AddReviewReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := review.NewAddReviewLogic(r.Context(), svcCtx)
		resp, err := l.AddReview(&req)
		result.HttpResult(r, w, resp, err)
	}
}
