package review

import (
	"github.com/zeromicro/go-zero/core/logx"
	"net/http"

	"oa-server/common/result"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/kpicenter/kpi_api/internal/logic/review"
	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
)

func GetReviewListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.ReviewListReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := review.NewGetReviewListLogic(r.Context(), svcCtx)
		resp, err := l.GetReviewList(&req)
		if err != nil {
			logx.Errorf("ListReviewLogic.ListReview err: %v", err)
		}
		result.HttpResult(r, w, resp, err)
	}
}
