package review

import (
	"net/http"

	"oa-server/common/result"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/kpicenter/kpi_api/internal/logic/review"
	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
)

func UpdateReviewHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.UpReviewReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := review.NewUpdateReviewLogic(r.Context(), svcCtx)
		resp, err := l.UpdateReview(&req)
		result.HttpResult(r, w, resp, err)
	}
}
