// Code generated by goctl. DO NOT EDIT.
// goctl 1.8.1

package handler

import (
	"net/http"

	okr "oa-server/app/kpicenter/kpi_api/internal/handler/okr"
	review "oa-server/app/kpicenter/kpi_api/internal/handler/review"
	"oa-server/app/kpicenter/kpi_api/internal/svc"

	"github.com/zeromicro/go-zero/rest"
)

func RegisterHandlers(server *rest.Server, serverCtx *svc.ServiceContext) {
	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					// 创建okr
					Method:  http.MethodPost,
					Path:    "/okr/create",
					Handler: okr.CreateOkrHandler(serverCtx),
				},
				{
					// 删除某个okr
					Method:  http.MethodPost,
					Path:    "/okr/delete",
					Handler: okr.DeleteOkrHandler(serverCtx),
				},
				{
					// 获取okr列表
					Method:  http.MethodPost,
					Path:    "/okr/list",
					Handler: okr.GetOkrListHandler(serverCtx),
				},
				{
					// 更新okr
					Method:  http.MethodPost,
					Path:    "/okr/update",
					Handler: okr.UpdateOkrHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/kpicenter/v1"),
	)

	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					// 创建复盘
					Method:  http.MethodPost,
					Path:    "/review/add",
					Handler: review.AddReviewHandler(serverCtx),
				},
				{
					// 删除复盘记录
					Method:  http.MethodPost,
					Path:    "/review/delete",
					Handler: review.DeleteReviewHandler(serverCtx),
				},
				{
					// 获取复盘详情
					Method:  http.MethodPost,
					Path:    "/review/detail",
					Handler: review.GetReviewDetailHandler(serverCtx),
				},
				{
					// 获取可填写的部门和组
					Method:  http.MethodPost,
					Path:    "/review/get-departments",
					Handler: review.GetDepartmentsHandler(serverCtx),
				},
				{
					// 获取复盘列表
					Method:  http.MethodPost,
					Path:    "/review/list",
					Handler: review.GetReviewListHandler(serverCtx),
				},
				{
					// 更新复盘
					Method:  http.MethodPost,
					Path:    "/review/update",
					Handler: review.UpdateReviewHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/kpicenter/v1"),
	)
}
