package okr

import (
	"context"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/common/ctxdata"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type CreateOkrLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 创建okr
func NewCreateOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateOkrLogic {
	return &CreateOkrLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateOkrLogic) CreateOkr(req *types.CreateOkrReq) (resp *types.SuccessResp, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	email := userInfo.Email
	yearStr, quarterStr, err := svc.CutDateStr(req.DateStr)
	if err != nil {
		return nil, err
	}
	data := &kpi_rpc.CreateOkrReq{
		Email:      email,
		YearStr:    yearStr,
		QuarterStr: quarterStr,
	}
	err = copier.Copy(&data.Data, req.Data)
	if err != nil {
		return nil, err
	}
	_, err = l.svcCtx.KpiCenterRpc.CreateOkr(l.ctx, data)
	isOk := false
	if err == nil {
		isOk = true
	}
	return &types.SuccessResp{Success: isOk}, err
}
