package okr

import (
	"context"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteOkrLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 删除某个okr
func NewDeleteOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteOkrLogic {
	return &DeleteOkrLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeleteOkrLogic) DeleteOkr(req *types.IDReq) (resp *types.SuccessResp, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	data := &kpi_rpc.DelOkrReq{
		Id:    req.ID,
		Email: userInfo.Email,
	}

	_, err = l.svcCtx.KpiCenterRpc.DeleteOkr(l.ctx, data)
	isOk := false
	if err == nil {
		isOk = true
	}
	return &types.SuccessResp{Success: isOk}, err
}
