package okr

import (
	"context"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetOkrListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取okr列表
func NewGetOkrListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetOkrListLogic {
	return &GetOkrListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetOkrListLogic) GetOkrList(req *types.OkrListReq) (resp *types.OkrListResp, err error) {
	yearStr, quarterStr, err := svc.CutDateStr(req.DateStr)
	if err != nil {
		return nil, err
	}
	// userInfo := ctxdata.GetUserFromCtx(l.ctx)
	data := &kpi_rpc.OkrListReq{}
	err = copier.Copy(&data, req)
	if err != nil {
		return nil, err
	}

	// data.Email = userInfo.Email
	data.QuarterStr = quarterStr
	data.YearStr = yearStr

	res, err := l.svcCtx.KpiCenterRpc.GetOkrList(l.ctx, data)
	if err != nil {
		return nil, err
	}
	resp = &types.OkrListResp{}
	err = copier.Copy(resp, res)
	if err != nil {
		return nil, err
	}
	return resp, err
}
