package okr

import (
	"context"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/common/ctxdata"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateOkrLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 更新okr
func NewUpdateOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateOkrLogic {
	return &UpdateOkrLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateOkrLogic) UpdateOkr(req *types.UpOkrReq) (resp *types.SuccessResp, err error) {
	yearStr, quarterStr, err := svc.CutDateStr(req.DateStr)
	if err != nil {
		return nil, err
	}
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	data := &kpi_rpc.UpOkrReq{}

	err = copier.Copy(&data, req)
	if err != nil {
		return nil, err
	}
	data.Email = userInfo.Email
	data.YearStr = yearStr
	data.QuarterStr = quarterStr

	res, err := l.svcCtx.KpiCenterRpc.UpdateOkr(l.ctx, data)
	if err != nil {
		return nil, err
	}
	resp = &types.SuccessResp{}
	resp.Success = res.Success
	return resp, err

}
