package review

import (
	"context"
	"encoding/json"
	"strings"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/common/ctxdata"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type AddReviewLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 创建复盘
func NewAddReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AddReviewLogic {
	return &AddReviewLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *AddReviewLogic) AddReview(req *types.AddReviewReq) (resp *types.Response, err error) {
	data := &kpi_rpc.AddReviewRequest{}
	err = copier.Copy(&data, req)
	if err != nil {
		return nil, err
	}
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	data.Owner = userInfo.Email
	departmentKey, err := json.Marshal(strings.Split(req.DepartmentKey, ","))
	if err != nil {
		return nil, err
	}
	data.DepartmentKey = string(departmentKey)
	department, err := json.Marshal(strings.Split(req.Department, ","))
	if err != nil {
		return nil, err
	}
	data.Department = string(department)

	teamKey, err := json.Marshal(strings.Split(req.TeamKey, ","))
	if err != nil {
		return nil, err
	}
	data.TeamKey = string(teamKey)

	team, err := json.Marshal(strings.Split(req.Team, ","))
	if err != nil {
		return nil, err
	}
	data.Team = string(team)

	_, err = l.svcCtx.KpiCenterRpc.AddReview(l.ctx, data)
	return nil, err
}
