package review

import (
	"context"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/common/ctxdata"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteReviewLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 删除复盘记录
func NewDeleteReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteReviewLogic {
	return &DeleteReviewLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeleteReviewLogic) DeleteReview(req *types.IDReq) (resp *types.Response, err error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	in := &kpi_rpc.DeleteReviewReq{
		Id:           req.ID,
		SignedInUser: userInfo.Email,
	}
	_, err = l.svcCtx.KpiCenterRpc.DeleteReview(l.ctx, in)
	if err != nil {
		return nil, err
	}
	return &types.Response{}, nil
}
